//---------------------------------------------------------------------------

#include <vcl.h>
#include "Message_Form.h"
#pragma hdrstop
//---------------------------------------------------------------------------
USEFORM("Main_Form.cpp", MainForm);
USEFORM("BackupProcess_Form.cpp", BackupProcessForm);
USEFORM("..\Common_PC\Message_Form.cpp", MessageForm);
USEFORM("RestoreProcess_Form.cpp", RestoreProcessForm);
//---------------------------------------------------------------------------
WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR, int)
{
	try
	{
		const char mutexname[] = "DVS500T_DMU";
		HANDLE hMutex = NULL;

		hMutex = OpenMutex(SYNCHRONIZE, false, mutexname);
		if (hMutex==NULL)
		{
			hMutex = CreateMutex(NULL, true, mutexname);
		}
		else
		{
			CloseHandle(hMutex);
			ShowMessageFA("This program is already running.");
			return 0;
		}
		Application->Initialize();
		Application->CreateForm(__classid(TMainForm), &MainForm);
		Application->CreateForm(__classid(TMessageForm), &MessageForm);
		Application->Run();
	}
	catch (Exception &exception)
	{
		Application->ShowException(&exception);
	}
	catch (...)
	{
		try
		{
			throw Exception("");
		}
		catch (Exception &exception)
		{
			Application->ShowException(&exception);
		}
	}
	return 0;
}
//---------------------------------------------------------------------------
